<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\Settings;
use Erlage\Photogram\Constants\SystemConstants;
use Erlage\Photogram\Constants\ResponseConstants;
use Erlage\Photogram\Reflection\TraitReflectionClassName;

final class CollectionValidator
{
    use TraitReflectionClassName;

    public static function displayTitle(string $displayTitle): string
    {
        if (\strlen($displayTitle) > Settings::getInt(SystemConstants::SETTING_MAX_LEN_COLLECTION_DISPLAY_TITLE))
        {
            return ResponseConstants::D_ERROR_COLLECTION_DISPLAY_TITLE_MAX_LEN_MSG;
        }

        if (\strlen($displayTitle) < Settings::getInt(SystemConstants::SETTING_MIN_LEN_COLLECTION_DISPLAY_TITLE))
        {
            return ResponseConstants::D_ERROR_COLLECTION_DISPLAY_TITLE_MIN_LEN_MSG;
        }

        return SystemConstants::OK;
    }
}
